// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 9, Aufgabe 4
// "Lauflaengencodierung"

public class A4 {
	
	// Encode sequence of non-digits using run length encoding
	static void encode(String srcFileName, String dstFileName) {
		In.open(srcFileName);
		Out.open(dstFileName);
		char ch = In.read();
		while (In.done()) {
			char startCh = ch;
			int len = 1;
			ch = In.read();
			while (In.done() && ch == startCh) { len++; ch = In.read(); }
			if (len == 1) Out.print(startCh);
			else if (len == 2) { Out.print(startCh); Out.print(startCh); }
			else { Out.print(startCh); Out.print(len); }
		}
		Out.close();
		In.close();
	}
	
	// Decode run length encoded file produced by encode()
	static void decode(String srcFileName, String dstFileName) {
		In.open(srcFileName);
		Out.open(dstFileName);
		char ch = In.read();
		while (In.done()) {
			char next = In.peek();
			if (!In.done()) {                      // e.g. A
				Out.print(ch);
			} else if (next == ch) {               // e.g. AA...
				Out.print(ch); Out.print(next);
				In.read(); ch = In.read();
			} else if (!Character.isDigit(next)) { // e.g. AB3...
				Out.print(ch);
				ch = In.read();
			} else {                               // e.g. A3...
				int len = In.readInt();
				while (len > 0) { Out.print(ch); len--; }
				ch = In.read();
			}
		}
		Out.close();
		In.close();
	}

	public static void main(String args[]) {
		if (args.length < 2) {
			Out.println("-- Syntax: java A4 [d|e] srcFileName dstFileName");
		} else {
			String code = args[0];
			String srcFileName = args[1];
			String dstFileName = args[2];
			if (code.equals("e")) encode(srcFileName, dstFileName);
			else decode(srcFileName, dstFileName);
		}
	}
}

/*
Sample input:
ABBCCCKKKKKKK
*/